%% demo for Cross-Scene Hyperspectral Image Classification With Discriminative Cooperative Alignment
%--------------Brief description-------------------------------------------
%
% 
% This demo implements DCA destriping for HSI [1]
%
%
% More details in:
%
% [1] Y. Zhang, W. Li, R. Tao, J. Peng, Q. Du and Z. Cai, 
% "Cross-Scene Hyperspectral Image Classification With Discriminative Cooperative Alignment," 
%  in IEEE Transactions on Geoscience and Remote Sensing, doi: 10.1109/TGRS.2020.3046756.
%
% contact: liwei089@ieee.org (Wei Li),zyx829625@163.com (Yuxiang Zhang)
% 
clear all; close all; clc

load demo_small_dataset
        
nnClass = length(CTrain);
Train_Lab = [];
Test_Lab = [];
for j = 1:nnClass 
   Train_Lab = [Train_Lab;j*ones(CTrain(j),1)];
   Test_Lab = [Test_Lab;j*ones(CTest(j),1)];
end
label = unique(Train_Lab);
Y_src = double(bsxfun(@eq, Train_Lab, label'));
Y_tar = double(bsxfun(@eq, Test_Lab, label'));
Train_Ma = DataTrain'; 
X_src = Train_Ma./repmat(sqrt(sum(Train_Ma.^2)),[size(Train_Ma,1) 1]);
Test_Ma  = DataTest';
X_tar  = Test_Ma./repmat(sqrt(sum(Test_Ma.^2)),[size(Test_Ma,1) 1]); 

num = 10;
X_src_all = cell(1,num); Train_Lab_all = cell(1,num);
X_tar_all = cell(1,num); Test_Lab_all = cell(1,num);
a = 0; b = 0;
for j = 1:length(CTest) 
    b = b + CTest(j);
    for i = 1:num
        temp = floor(CTest(j)*size(DataTest,1)/num/size(DataTest,1));
        if i == num
            X_tar_all{i} = [X_tar_all{i},X_tar(:,a+1:b)];
            Test_Lab_all{i} = [Test_Lab_all{i};Test_Lab(a+1:b)];
        else
            X_tar_all{i} = [X_tar_all{i},X_tar(:,a+1:a+temp)];
            Test_Lab_all{i} = [Test_Lab_all{i};Test_Lab(a+1:a+temp)];
        end
        a = a + temp;
    end
    a = b;
end
a = 0; b = 0;
for j = 1:length(CTrain) 
    for i = 1:num
        temp = floor(CTrain(j)*size(DataTrain,1)/num/size(DataTrain,1));
        X_src_all{i} = [X_src_all{i},X_src(:,a+1:a+temp)];
        Train_Lab_all{i} = [Train_Lab_all{i};Train_Lab(a+1:a+temp)];
        a = a + temp;
    end
    b = b + CTrain(j);
    a = b;
end

% Houston13 to 18: lambda1 = 1e-4, lambda2 = 1e-3
% Shanghai to Hangzhou:  lambda1 = 1e-3, lambda2 = 1e-3
opts.lambda1 = 10;
opts.lambda2 = 1e-2;
opts.Train_Lab = Train_Lab;
opts.Test_Lab_all = Test_Lab_all;
opts.Test_Lab = Test_Lab;
opts.max_iter = 100;
opts.dim = 20;

class = DCA(X_src,Y_src,X_tar_all,X_tar,opts);
[confusion, accur,TPR, FPR, sample_num, kappa] = confusion_matrix_wei(class, CTest);   
